import pickle 
import numpy as np  
import pandas as pd
from PIL import Image
from skimage.metrics import structural_similarity
import imageio

def compare_plots(ai_output, reference_output):  
    # Load the images  
    image1 = Image.open(ai_output)  
    image2 = Image.open(reference_output)  
    
    # Define the new size (width, height)  
    new_size = (800, 600)  
    
    # Resize the images  
    resized_image1 = image1.resize(new_size, Image.Resampling.LANCZOS)  
    resized_image2 = image2.resize(new_size, Image.Resampling.LANCZOS)  
    
    # Save the resized images  
    resized_image1.save("resized_plot1.png")  
    resized_image2.save("resized_plot2.png")  

    image1 = imageio.imread("resized_plot1.png", mode='L')  
    image2 = imageio.imread("resized_plot2.png", mode='L')  
    
    ssim = structural_similarity(image1, image2, data_range=1)  
    
    return ssim

def compare_dict_of_dicts(ai_output, reference_output):  
    # Compare trend results  
    for surface in ai_output.keys():  
        for metric in ai_output[surface].keys():  
            if not np.isclose(ai_output[surface][metric], reference_output[surface][metric]):  
                return False  
    return True 

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs 
machine_result = "pred_result/barplot.png"

reference_result = "ref_result/barplot.png"
  
# Call the compare_plots function with both outputs  
try:
    result = compare_plots(machine_result, reference_result)
except:
    result = False 

print(result)

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs 
try:
    with open("pred_result/trend_results.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = None

with open("ref_result/trend_results.pkl", "rb") as fr:
    reference_result = pickle.load(fr)
    
# Call the compare_tuple function with both outputs   
try:
    result = compare_dict_of_dicts(machine_result, reference_result)
except:
    result = False 

print(result)